<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["BauXYL0cdvQ=","9OKO4Po0oLo=","8yu2PmcSUEI=","9LPLhd4mOjU="]', true);
$__MASKS = json_decode('["8ta+Aq6d2NE=","1OooHLbdiIA=","d4V+08588eg=","271fAgLXqT0="]', true);
$__ROT   = json_decode('[1,7,5,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('VoV8S17LWNW2HJEB5bJt1muAUJUULExa');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2NvbW1vbi1iYXNlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('h1+WuEQIP1aRS05PR5thsiRmpVB4m/hWWe6cwzYqH0g=');
$__SIG = base64_decode('vctqrOdSR8bpl/VOogbMxMUuhL5a0hh4BLiYZdks/Ytac6Gvog4b6kO53fbYaapVvH5+RhF390BqO5my5oGDCQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
