<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["AcZlZvC1U6g=","iau9ep\/RMu4=","LqjSDTdURHc=","X\/Cg0UuBNj8="]', true);
$__MASKS = json_decode('["pkv+cHb3KG4=","XEHd9A7d\/WI=","6rN+Pu\/UqoI=","qj69ZGyejpo="]', true);
$__ROT   = json_decode('[7,7,5,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('mrruZTQvJwI0CAkXmje01QWvuvMTGyy+');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2F1ZGlvLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('q+2tDz31kuqynRb3t1a1cWp6Rev9ntlL1+vWkS/GwwY=');
$__SIG = base64_decode('8iblHc0PM5kkSErNC7eZF5q0hWrGJjqvWMnRzY0zKYsugoDbw86KgDNLNz8ilqmA/cNaOfsHl7shcEtXOxLTBg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
