<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["R76roVgLz+c=","FD4SX29nQt8=","0PSWVc8rdOk=","AuDbvcEX1wE="]', true);
$__MASKS = json_decode('["Js1bdvgI\/0E=","rLBkdDbNx6U=","HIy8UJrOAwQ=","K\/DrTewNb8g="]', true);
$__ROT   = json_decode('[2,2,6,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('FS0i6kqxso2rtzi2I6CY54So1GWsBYsy');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2FsZXJ0LnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('/BH8F6FaU6IeBb3t7kHJbdecKtnUmqe5ECyVkD9800Y=');
$__SIG = base64_decode('YbQl/3k0siPBBhe7Pzl+1iavlRnmWLYzlaRiYPs9FLtmfJ6lOjrbWZ6QTfz0wusPXvD+ffazcR51N5VWbjZBCw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
