<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["eKH1MD8BUwU=","jLnQAa7rRiM=","BesekVXZS6A=","lLtZFBiPaCA="]', true);
$__MASKS = json_decode('["qCxEQdRWEt4=","zTvMrSfsDEE=","QplzD4mvltE=","0o\/deWBMuFU="]', true);
$__ROT   = json_decode('[4,7,7,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('9wjpVnxh5E/xBMJkgmVj6wEr821/0ky6');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2FjY29yZGlvbi5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('bgLlvcO3lVTAZUb+UWFdJR4R4Gnmb24yXpY6d2ABpRw=');
$__SIG = base64_decode('84JvzjzwSntT0w6N4Uhjvqs5mik9OsHkcMGndL4kITM0eUobfs1FgGecpV/Rjei0GcVlCJ+hhxnxJ4+vGIeEAg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
