<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["+qxlRNDG8vw=","d5Rm0lJazNo=","ghvpzWbgwMs=","gdLLNCDzOlw="]', true);
$__MASKS = json_decode('["kf8AaYwGkCM=","xrcxcASQWsc=","ezNusWR3kLo=","S0iVavmroEU="]', true);
$__ROT   = json_decode('[4,4,2,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('u4G30ChfEyGt5L9mcLfYLoGXLKd/3xHI');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy91dGlscy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('W6KsEO/YUUbwp9w3zN3bsSBQyvmWodGoFdlMo3uEyZE=');
$__SIG = base64_decode('2DW+QFgHOCW6zTTPg9JYh2V8+M3yEX1qCN2nw3k7hctrJ5WKP1tXH95mOdPz6BpZ78OpDxzbRbyjG1Uf4w5DDw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
