<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["LkaZIUiMLvQ=","i2tEyChMrc4=","sgJ4rbK9l\/g=","meyerbQtFJM="]', true);
$__MASKS = json_decode('["iDn\/XoWgGDM=","RSN1tUQinac=","bAG4Bmas6tw=","OT\/GL41xcWI="]', true);
$__ROT   = json_decode('[4,5,5,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('4ABBrCPUHYVaCvSyemouNuDb+mfHYrrl');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy90ZW1wbGF0ZS1saWJyYXJ5L21hbmFnZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('JU1i+T91Dj1e6KXJNBNoPqN6cImb1nYkDdHN6WVsBCw=');
$__SIG = base64_decode('6FU6lm4cbuVY7GDjJJX4Snn+vg6rAc2u7Leh232dY+Irr1PX6nFwzox/wk6PxuWkKgx2oyTzHrHhs75rhI20DA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
