<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["O8W6NhzUaTk=","kS7N7evgVdI=","G0Wlz6rWPOk=","+DftyQga6v8="]', true);
$__MASKS = json_decode('["QUpHsOSdR58=","vYH\/ZtM9XBA=","EXqSRl9jGns=","SMAL9x71CvE="]', true);
$__ROT   = json_decode('[4,7,3,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('o09mgwjOFvkLb0rGFwofV4lpJpkXCUcp');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9zaGFwZXMucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('vdA/GBk/QQr751MhGf6//Jt9ZCcUid5B6nX30czyCJY=');
$__SIG = base64_decode('DW85d7VBapwKhlN2Pn1nA3z9LT5/m5wEshcLLMJ1nyNbLt2blQyTKJpo2q8Bn16QFnrkaH0jRf0RguMkYPLdBg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
