<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["YB74ZBWB9VI=","eorjLqZb\/\/g=","XJR5Fotw4BQ=","j5F59gf5eiE="]', true);
$__MASKS = json_decode('["JEtUrVnMAo4=","tEWrFPI0hYI=","tsLrrKIM+fI=","Jlh9OQsEbBA="]', true);
$__ROT   = json_decode('[2,1,7,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('sYnJVNz0+pe/tL9+irxg/FxOjIV8RWOw');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9zZXR0aW5ncy90b29scy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('z92vPgGkKpQbOvDxXKtFbys7XwluAMCqK929RCixS+E=');
$__SIG = base64_decode('dM43klE03KajiaQywbY56NsC5tgM9iKt9PpRTWc8wnprGhQ+O9/h2uAaJtXP/95xoFwMrGlVTF548Wrx3AibCQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
