<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["UyFJhPXLAY4=","lF8r9RaL65A=","WaKhzMMBlZU=","tjPYEBxdOYg="]', true);
$__MASKS = json_decode('["wCf8v67k7ic=","Oz+v1J5xm+U=","3pifn+qgPuM=","YQyOYO+b4is="]', true);
$__ROT   = json_decode('[5,2,3,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('lnrEi8YL8ckf6v7ASwrNMuY+H2AhCO/o');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9zZXR0aW5ncy9zZXR0aW5ncy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('XaxSHeLqKnJW7yBnOQvUBuGuAqJDJXO/UAJcUUxrKE4=');
$__SIG = base64_decode('ahmgZXghGS0UISCin6iSL5xEXPSUJ4oJnSroUobUvDNhCTi6q7y6fToOr8cu1C2Q/FJbS96o6YWv6knMcu+yCA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
