<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["sP0UZ08D9fc=","cL0\/JEnUEOg=","g0hNVCxMTgo=","0N9U7s7Fo\/A="]', true);
$__MASKS = json_decode('["na58v\/\/zCk4=","GEQYpoGgFKw=","NLpNUJgjmDA=","PHb4\/8WBUB0="]', true);
$__ROT   = json_decode('[2,5,3,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('I9Zb2n4iibTh+6W7q+glwpSM4YEaoeZ0');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9zZXR0aW5ncy9zZXR0aW5ncy1wYWdlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('O7SLDyqLanLbyyV45vO/uvl4uEiBGE+iDAzacOziLI0=');
$__SIG = base64_decode('NNfdIO3c7h5xdRQWZ67M0VS3uXMHDctQzpIUIDtbbhoZ13geozXTWR2V2ix2R3qQcLXXp+sGzfFNzujeAqLLCw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
