<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["hI9pKWTPUGY=","xVxmgijcEo0=","k0O8QHYVOJY=","c+XVJAsAvdE="]', true);
$__MASKS = json_decode('["9oiXOllhuBg=","5pLBquWvJZ0=","Sdg3UYPX8FE=","kqFGmL7Kc0I="]', true);
$__ROT   = json_decode('[2,3,4,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('tu2JptZS+uOFrVJNQEoGHFCXWuhxz5cl');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9zZXR0aW5ncy9jb250cm9scy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('eeCKbrElauRH+gL43Ai6zfGl8oUc9j1blVc+a+ZgV2E=');
$__SIG = base64_decode('z+eEY+STNnUUBxnF8y/dPpa8uoDBMSg7pS/b17CNM6izxA/zhh0gOknRHrJ698zLuqEvCKTctW4TFTgC2X0rBw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
