<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["HQbDpjAApkw=","qC+FC59I1RA=","jOZ6aR4p3Og=","y5MutJQG8\/U="]', true);
$__MASKS = json_decode('["cCkx3e5qmrQ=","WGnvDGc4ZKk=","mr+ZI8Tt\/+Y=","r3nAqYbsX0Y="]', true);
$__ROT   = json_decode('[7,3,6,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('i7oCnQXoTbHTYtx0VNozlxvDgRhGOnzh');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9wbHVnaW4ucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('Is2jTSO/t2H8BuH6W6wigGGZLOsEY/LRGp2YMyYrXBk=');
$__SIG = base64_decode('xxgRxCl14daQ3bu5QN0IAIwkTXknngsA/WbFG5GqwhMveg968s1HHsjkhz8JNGd3kdVqbWj2TVlAO0ZFplyTAA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
