<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["ZyhlMI\/h3+c=","u4ag7Pvqz4g=","KiVJFSTjfXA=","YIit\/H371Sg="]', true);
$__MASKS = json_decode('["o+YIcubBeSQ=","Bc4ElSPN35I=","KsJiwmJhmG0=","uIQ1vyJejhY="]', true);
$__ROT   = json_decode('[6,4,1,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('GqS8cpPyFzPjSmX5mlab1wo0tP2pttu5');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9lZGl0b3ItdGVtcGxhdGVzL3RlbXBsYXRlcy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('DjZLPLMfuU8XEMtzeAVvw2mmp6EVF+EpP+fwPiPgoTk=');
$__SIG = base64_decode('of0RLJn5DCuKrG+sj5Z/vyhfGxyHY/l73iAHNk0qEUz662P96yjs0DHX2LAaSB4duOkZ6QFeCmhkpKLErZ5LDw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
