<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["H+3fDqcZ05k=","ov21cpTGKXE=","ndGx4Xf4lAk=","Ps8KdJ9O4AM="]', true);
$__MASKS = json_decode('["Bf7IWVPg\/rU=","4\/xomRyVew4=","qb9iFKgrQwk=","oNRrb6RFca8="]', true);
$__ROT   = json_decode('[7,1,2,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('LZ3IVYNWu6fCInyEJpD/5FQN45RgoFez');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9lZGl0b3ItdGVtcGxhdGVzL3BhbmVsLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('umGfUJcTWpRvsTBy7RAi3EddNWP5MIjAeDIv5/0+rPk=');
$__SIG = base64_decode('XJkbfHvAUAszoWtDLRZx8nLxQKkIhEwt9Si1JZCpLKZxFhEof3B7d88cGVHHTN05SbADZWoq1ynHMsry6iEbDA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
