<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["mMvVO5NojcI=","2QoJMLZ814E=","qPtztj3yd3w=","UZSsmKxwXCs="]', true);
$__MASKS = json_decode('["Qd7ZCeRF5vo=","\/UDJmhrBE1Q=","GXuQwkFZgKI=","LMHJARITV4Q="]', true);
$__ROT   = json_decode('[4,7,5,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('Jsm5brZJV5PJzVXn7CDBSGERwP/oP7mq');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9lZGl0b3ItdGVtcGxhdGVzL2hvdGtleXMucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('LkBcKzdwLDXXytA02e1qoIvH8QNDoUwX2lYk3SWKm7A=');
$__SIG = base64_decode('UqmjFo2iUrO1Fpwx/TfZioTPhJv1C3owwwyxqgjsjGWdBSKMHzwOvZgGMc8JC9IwVNU7dGI3QupKbkGTGc2TAw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
