<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["lHPG3EQ+86g=","0qQT9zxbTng=","Z48ID3AYcrg=","BwR5ZDjwniY="]', true);
$__MASKS = json_decode('["eaQnhXH+85A=","wRgqV3uYoFU=","Y3bdpYedO4s=","X8t\/iwgzvXs="]', true);
$__ROT   = json_decode('[5,2,3,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('TCTh9bIPoDwHRDOhivCH94od2V84y9RJ');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9kYi5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('VbIVfb+U866k1FJTvjEsBx6u9xDHFAzh0BxXTbCQoP8=');
$__SIG = base64_decode('oYdp2Rd5LXS63iUQlNrAr3jDzaKDrutOeiil33new84/z40sVfHKfCkShCqCT8MVUu4N3giher6E7A62RBIQAA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
