<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["AjaS9AIT85s=","z1oT9Hlnt54=","spBTU4kL1zA=","euePip4X2iI="]', true);
$__MASKS = json_decode('["CjTcgauTr3Q=","MNJrcnY3SIY=","NQ5jZ398go0=","C9Z6v77ny+o="]', true);
$__ROT   = json_decode('[1,6,2,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('4wSv6I+/7/kOQz9Vbrd3dqkupSzkfo8m');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9jb250cm9scy9tZWRpYS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('gTzpK11jHZRPV74G2cUOfTmIl0MMRqXenGL0lYtKOu0=');
$__SIG = base64_decode('FHv5gMjMUzrEVrSeQjn5hucAc28kMuncwAGsLwR+e1JMWy2ZZPT5lexyIAb/DfcYQivIj6WrfjKwk2SJiOIfCw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
