<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["Ih+htzK\/j8o=","0HFtzgoulsQ=","+NsVjq\/TQb4=","dSpnct3TwMY="]', true);
$__MASKS = json_decode('["XcfjZFefuX4=","FFbE6cpODYY=","Bk0rtjqIokw=","c2N\/FWBQAtA="]', true);
$__ROT   = json_decode('[2,7,6,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('SxxNQvNd/H8I1HKFM3ZuYvvf2ck/sUiO');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9jb250cm9scy9pY29ucy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('EyKlbnloWGQc7u7rEsF9G4K2BbBHOjfWqFR4p3sDevEgFDKpjbJq5R4souWvEXAjjeHeR72k03iI+ieuclxGW8PaDsnlfMdom5XWmnkINUv5MYGNyu0z+RWfMgXxi3E4P2E2cM7enLkeRzlbOeqN+VjzNp0ffxI2tJx6wqc03N2uFSbIJ2uwXN3jIF4W1XIT7vsBSQ+FLyyJFheRkMFIRaI+/qBeGZst/wanfwlsfgLMMUmxaZ4dG59fjiVAHTAWMldZo6ekMSkyTE55x01Qn2aPqfR4OuPWHpOgy+Ay1Qd0P53Oo+gBn1Xsx9FnS8QBTggtdnQTDbcAeseob1wL8ZqFyrn+KYmUp0RI1SIeefAiaGpTYJi29NmzC6BBzkFOMWHA9d4SGe42bFNm/GU5YMC9EVVHjedRQB/WBbsHHhmZHiDSrJPGQq4JB4DPNhGX3StxRdr9IBCGDrIw+QcLNoNj80ASENQ9wXnkXcHnetmufCsCWFnnE3n7xCl/FSY/SV+RGfCvy6wCfJ2jbGngI63HW3Wxfq/FyYYebQtfDN8WD135ToEAn/l+DgoS/KjZb77W/RUfxUwf2crNkbDkZX6VitLe686YgkFDLqrrkwJAE4kWwVR8xvmi4rZfxgLvuqK1hbuL+Ay71P9/Yj3iKPN3WGnYglLo6tjCW3kUhKrGTUebS5NexqjWnye32QQb1Gep0eVuS00kGRpNiScXrn2IaOWTEcso7s1PdJB2a+9rCjiG7T+wCpnuLYDdIgUab66vqKiJPGDjjWGmsbnea83t9gwvGKRnAtdgQSi++lvKwNJlNyobRKtso8ZmteNSuCjDnx15fmeXk43qVmSZUMgYYjzEf8EsZFGT4bERRBiFYIAMMa7384kM7rDBcvTPM8vB8bzrkc3HT9dqHenbTMtIpEOA20/s+rvgyduG9ZjLftk2IKl4kVRfRE/7ybvs8wEWZn9OxLRHvxuz0wNYzDV7Q/By/PdIxpW/+Plp1xonqrAj+TA5LI2e/te9jk/JtYpBLOWujuipEWgsS3qCxZfUeRiQ5h+bd2NXDZ39IqTaP59sK6z3E2lR9uuepIdY0auFlFjt+rOPncyNHAphA3iTHIVJ62i/VauyNBWYlYB1Jrb4Zd06RcpmkaRg2YKM+CY7jAIFlPRKpVojGeRXb3FVQH4gdQiMI3X5cvJ4NSWOKL7X2urKI0S2yp03Csn0zvZjC93C6JA7954xsY4vCCETRe8pSo6491y5r2IplcnuFcpa5dPTICaqfKVB66Q0FZHQq7GsVw1/QELOa8L4Fh7l7LFff4xZF5xy0pa4R64Uq9jGh4oZ/RyMUe+Ss5S9sKyTJSomIyAiaPd5LDvgFJ/ZIWQ1m+xVFlUMOeAYAgE6vnv+fDesWLElawsKz9HN+u/pqVKcLGnwrWbEZTj7WqByNviJkQl45Jz+kak0LxFuX0840v2CTXpTlS71KLpMWRkObiidvN6TwPpblxuxwtqB2ew+t3RhypUdSxm4h1G716Fx2zesQZ+ez3k+GCgl5Kq/Ianay6NAhqjloeAedGjsboQ9tlolv79LHqdLb8ihEpsRk9PmP1EN4M2K8ikOTUR90UAMJAyUCJHeQm7tVyZamguNU6ewnquJkX9+2dcrtlQdqHzEujwtqOAaRxdP+EgfJIsxAJ7GW1MN8dUFLKuyAwftjErbrJE7o7ygy6OfqxRponotwWeWDME2l5YjrymvQ3C2obTRLCV57UfILkB1OhpYHGPx2xorBjUR1Bx0u+oCfMwpLGIbTOIqZ9m8b49MWQRVHjqcrj81LL98ykob6jU+iGvfe0Jo8owzC6GDalJgd16lVH4/NZYNp9U4RjjzftZm9iCnvwHFwlPHg82gGg3LHGHX85/aqA8PHEgACNFWFFPZAwVWHLrLkxQrxUheIx5x5vWfGMtjrzGmPpKlsYtiD2xu0Rtdbnii1zpM0js2KsRqWUbA4yMEaNmbJsm1ldqIu0dpxeW4gNhFaTcYFa99elVThB7T6DBHvGSbZRJXWtOYBI5LCrgGwHQLejHMPaq5Stt+udgpxlb+iMbceMxCzZRX0n9UFKZqj6gLG+3X+p7VvecLVSJCrwpKMJ4sGN3ZUKbdcjg+6bZh1+ZUgiqhBxRnOK1lFv571o4M8JYi8MeA+uJ7sc79S7lS8N8Vz9k/C4s7lC+T0Q2XNGcLF0vzscKa8GXZw8tjW4n18PpjQBMPrjMEmw7U7O+B77l6jK8xxkIsEVO69g+U7WdvQoeuIMU5SSXDmGDvplOVz6adig4PLcp6lt5AkaIULBvxwFDiqnI8LmAH1Ln5wwkRF6zOr+vLq0OLo5yihf8CLuekDEIcuis4YpPOjeVUvc6duH3MRCDyc4GhXbkoiZnNN6mhOyawgceQUe6II+u7qQaOGVjMrfG2KposFA8U4pRuSbXBIzh64Ejy8YnmAvC2vm5XAY9MRQv7+O43gtPwRlrdl6MvixBx3XNol40QwpuR0ygMFuh8iEmj16xpHDaphojbIWiP0rQKPfdTxBhNVs/2BTToPYT6Yc682okdrUi2ad8PL+SmKo36Avt14vwsIsb9yWGqjLRihFYGETlJggTp5cVZ/0A1gfA+m1KtzJrycDF7Wzw+17EdVmfoqkvKRp0R6cnjcvjvCrqH4huwkuoJ6JDJz2fHD72hs4BwKDP2ZSz9Do1ZTYTFSZT88ZCyyU4JcyFwcFCM5dyQmArdZ3ogLjzB4Gbkb8NEJvyZ/SIccAUqRocQQ06uT+dcIUTQghzs9WoPdGPgPV/hdokTGWIDdEnCz7lMa5w6dVcZepr9AmH/ev8KIsvvEFnbDGEJicXSuHUOXiGDnyzstE4AnTIW+OgUPNVRfsPY7YhCEX/sIV2ofRS+vVuhzEjtvbHOvXx788kwtQ8PltgQ9ujdeqLQyTFS5U6WCuw4iwaLuWne130uIEVXZfMd6nwIFZe2gKq7ygeaz6mS5EgwQFaPLuKZArGDCZ8ncooON8ymDbdnp7OfHWoDFl1b14rakOhA7MftW9f3JBOuwZNonfNlunW+Y4gK8YrZ2vmS6bc1GfCS/p8BzRcct5+Dg02JMYfLKAS2hrNqH+OhEv3LGfwjmebWF9uJ0xji8FltyxyTvoLOkMDm8h8qV8fO/ea80UA93y1ituyPPpJQ9rYeVy8gmt6LLbxWsCZsfOCtPP0qJf8+wHd2QX8bGV1ke+WeciuM2bfFQklUHSXmbN5PTk8iK/bLdZY4ZqpQTiknC+Cj7u0FTqahNW7gekTe08sTtpQ4TwcRa0r4Oh2KMjaHALaVz+1L4i/ov6ohkwqDo5IBU4NiadPAKggCimShgQ46+HbRRQHHPFRaY3rghfctbT6QYwBqMdwvUXEzoy8FZTL28X9XZ6A24Cofz9wHG97Ex1M/lKpTMi+62xtIL0qFime7LUBKTWfwbCImCJIP/BzcJ4h8Mb6DiQ/P9CRiCB0LM9zgcs+Qo0jM9i57645eEo/rdYJtJ+Fp0lqemrCdwhFDHZo8laQQbitU9Gj+wo6qj5opG6fWRpn1V4mr8l65LgC2GUMMZO8qcZB66fXmSpFQokrcTJ+RLyN3b4FUHzDjbPTcHVZAv8V52s9RFQAn/JKE8hQtDkxcJZCoje/phFekoASUSEmKyEU8tEPdML8RvQ1TZcnBj7EOqe6woC0qGeuOpiGKhr6DF2kNARh72zxRZslmjZJsBChIliseN8HcTAKaCDlswhlXSm0Pp9/srM/OK7GmJzxRzJ2skZq3Egw++m236QJiaTqWJdALfNm/mHJag7kvn+WgwRI90LjL7kqHF8opsoH+KtqE3etT65OABSc6S/L+i38xfuSpBWGojFiWlSccQ+F7vL0V23TozIIEDGSrlVp/7ey2nd/8Hk4Ig41A4TwLF1uWTEvvWZvKRF9NQ1/Bdp9s+Xz1QG5xFRN8qSy2idOlvx7/FAD8t6K/IA5zoX50Sm8G5CfOPyvZewOPRJ796AtSTwPekk3QVPR/09r0Y+6pXglEA7F8gI741Iqm/GCTj2njZWhCE4SEJ3WL2yEc3Weo/C5r85l74S7Lb1ICA0asVibiP0RSmAiIAcZkm/ucWUhX0ILH8KpNZfZvCxwRQlPWj5ywpflwdV17CquuJRnqBBX9AuAAPCLvGBSIOM13oBHMtmhTPqVKQACBlRcsNXreEirYOjNljr4XLnKc/YIAFCX4i0a3IX47xBD7axvZweSPSLAAxOO1WRSi61/uHVz4jycjs4Egn1ZjDhJOnqOI3teqlVzLSY9MXOcqxCIybJeHiCxcAwF86Hwpw86yW0SSAUBA6YlFH43SJjfhBWQMozGHUD10UcEfLO4tU1JfB+5dW8iIAZ02DCxoy1+pM5O9VQcNJlHw2G9Wo8W5rUG3cESi3ziwpSplZhPBacXc56RrTrFe+KtPGNodbSNhDNbNtEq6Q5QJEvjRaAIMfNVnBGJga7ECse7Ago4qxLBTTU9Q7aukb2ZcX8N0LS38iLn2rScojCWq62LnF8THUj7CYYct7eavMIcnhtq0QML7VzYhhUg6u8M2Y3B1dp1xfNpO26v62YoHlqEOn6ERO4M/IkD32mkRFLpuG8fFuzi87EXS2Rf7tY3Sn3vKrdnehpIQzNVquDXohJ1eGagIgLgYnmZdVaTzvbAh9MN0iL1m8Q4ovZQ2nAjbyOQVQbAZGkDs/OPR5b6Xb6tN+875sGab4Ccpkz7p6wKm2JXf+uETKuHWP8Cy4AWNTlUyywarJ1bjYtt+7BsPK+y25s6ytijKcJKGC6WihHNzPSJkdYWTgWXfewloo80vklQHUERtuQIQ1vH6pFR4kiL+lueeHbE0ADYc7Rd1TAWIdsvMzwqZrv1xLRm10ezSE0NIkOkEgFU0pdlWx9f5CiyjNF3nYvlwpbT7hL7RgB7B+Bk4sCe+59B2jbbSd9joYjzO5xKrC9+7TNxPJClYznb1Kz0bPoaieLX4VJLFVUcC5WOJQOV+3rie7ILHY0kPryc25SgbxCjAl7I+1jhWGJlBcfULYLmi6Pq9O/RMk9IIDPBVxq9+awrvJwrjfDbQ4bQPrMiDA8WG1/kosj8q+kT6gCmbElhyzNe5XYHQjLq2ZsGJsmG4nY8jpW6zHyZLFjuHQCCtaqVg3+FSMZCu3q8mQ4lmpD7mkr+wuqHhXEXoUq2Hhau0DWOU3t+Zf7mK9lEIhg81n1nJbrntV+XU5Zx2lgTAAqz2dUKgQ2xzb7utkGvHso3d2Kg+Rm+O3LFuVQ15g5IweoRf+xJcNNFRAFeJ/x8e8KrvQxUJMxtDD5MVXmY0zepBzcqncJ6zpKYmoZkVflsNWmh7mQ0RSdc/1xqM6DP/olThJsyDFziI28zxgmbP2YJ7rUn0b9Xcy+eR88ijMfK7rkJYhJusg+pUs8d0ZTrj0pMfrlzT0CZusI6mpiYkfiXi+BkTADZ634A7x+8yWdYNZihEyfFGJoQkgim8c+StP5sHD/1H4tzwFC/lr5RtijhylSBG526HH4Lmv0Lo2sRkCbP2diLJz7KMDDrxQvhexsoT1iTATMdMmp1ZzktU8nuRPJk0Bs9u0xkXisGume90GwlD8nT6mg21Uccm24fGKZ/U7JSzNoOUN1h4f07zgFW//PegnA+Gsz+qw+PG4RJh2qkzJjdUnEzpGevoUmrx5Xw19mMuICRs3xr5vyrJA9YQ7xXogj9yMqWudXfnbBGVW5DsEZzvZE6cowEjAJOu20OFiBpCc8r+fwioNoWIjN7CnnQI8uRIdsBp7skTAcKrwxSROzzG93EXHyyfhHnA1D3rhdII4mT6sjy4oS9iDlcYOPTW+Ufw8oxI0fF8/s84E3/f3ji1D1aPO35BJ5GFQClAyO+nGnte1da8fmNaTERtvOa5Onu4wECJsAsweU4D5HwqpxTFhjkpju1IDIawi/3whRlnw7gNL6HKSNNANahRqmPSEYSqrjLjn8ox6+5sQke5VHd60Jw8oiSU0D8CwfZjJCfe5FEkC3mWGbLrsnLWxw6Te7/D/5vVOl65kEN8Byle/se2YU0eoEJOBC/XewfySWpZD6JqHooDzOC53ewQbHLJIof9MaJKbNhX/tHi3InD/HL8mgZU4eadsxaLergy0XsdXv7ac+fc1qY3xKQ+MOSdMnNYIbzSknvS6II4dvIot1fnU5RukaXQfoBKrrVbo6wUXANITgLrCg4fYRvwPa8pkLBZWsw14hH9laAnhOBjzX8h2RFPNIkQY1yVuZS3nWFfpwTdH2pZ8keXobMlzP/GFy7Gy65pQTHi64dEZuW+19o1Xnu3x4yfzolQG2qAnvNPNrRhO/YhATG1/UTPM+F80Y82bOCtMdcadKryYMueGABlv3oLZnXPbMFVH4BtYTYMbubx8M+cpuHhUkYreX0Z4CKwzgec8hvcxjt22vZv3cbPp583THDlOegRN2Qg6Tvh1jEDVZVi1gMZklvDecP6GfS00PtKrjLuhljZyfEDKg7RSVUcJracMHNONbtbUplGJVn1vtGZy89HyDmi94n+S39MmCxsDInkD1TOJAsqkDbkz8rcKNyDuJ25YNfy1umo/KXdXkv6Ev/EIvbhamcfHyDU7fEPREGoIc/ierl7gdQk/gfcY8Vm4vBGX4b1c0dItx1zqQk3yQWYLNdJYqycLdDE8aEFHUIcKzbeRKFvaqJRtvZ4I6c6JThUZ9g52B8x+OwKZmjjHg1WJMPMOSvpErmZJUDHkK0BaLf8nmWPYiVKsinWM9HVVIChT1thTSmAwrkTjCZR3G/Wf691iBhLFNEkdCA1jrMTyayzjOSCgaRa/zoP6bP9qCaDgwQQzcpFEJGuPvZv57DFuu+IalLNhn1veGsAnD2hRMXdvpQcKjFd3GONQhgDpWIGMEvtsrQNs+GA8FQ3QzMi77l/S7GYMYB9ze/ThFKz6MUfdCOlq8hnfsBcTXPvkyFAiZJDsLNyn+Rvqy9Y0barw/CwDKjiGjR2qoNGIv9i1pnt5TH74v3cHJUb1xtSIQVbwrSjUQzcZ/MPC8JwzLUGdiWj70QYNTs9WfXoEskckgRDPikzhjG4n5FFZ8RoMjBSyAzZtM9wycH4YGPI/79Bz6BpZWHg4T3WvUQvXtF1E3d7lS0fAILiavgcypvpbmkgeJOP7ZFGTZZT4IoaTnoDstfo/pZprd4B8B4pLFB3n2ZCaM2roWpqaJo8lV6yz1Gl2G9QOICBGFGFGcPkpCxhM8ZpM8mhXy/rYKm0dSFFy4R6I/BoSNHlm5xgKRhqZ86FNxfRkn5AMShB/QJZdNLUD39aI54UNonJbPUVvVj2iue2108MTxFGdU6DxFG6M1/bgKFa1Egn8k/T6mgTaRorEaRcgdNdSE9X+e8cuP7V3vsp+JsXvsdo6YBq4yisIzhTfHq5UH2LNJFarp0leO0R/0hwUtw/idVfvyZh4w8BUELareDNynzlHpFH6IMdwNq7bfyPAvbkRIqAf/Q/vZ0gNcuS4TcOX8jsFDPfJ8MdSu3pzv/2n3EjB3vHun0WY/aartAiUcpmWQnTBDLqeEt7qQaUSg3TJqn9Gsb/Js0YlhRvW+LuiM3FaqvkbqqhadhfvT6uevq9cSuey64GN1BgZBlbQhtuFE0MpB3i363L2MTRt/wmGvvXH8+ijcFtxWcj/MysblRs3QAbHW/PV8mzDKi4obLa9P0kgZ8NQ9XK7+PEGY8BxMcrLwUZxeOnoNdPolnKlHICHp6Ylg3l2qz8qdwxUUOkSMKer7H8V0ucY02rhifokLTe3knusaXJPGbVa3rC5WTpoQBT5fnAk68BWLmQHzbgOrX6YGXr7u9oo0JXNDMe6D7vYdx3aQ/3tYYv9y5wB0O6nxce59mrYJ9jr123lJFTNSdnqkUlmBvjzkKiUpe4DqT+go2AmNjJx4NaRoQHH38voozKOE9NwzKYLmYrn1f1rbTK+koHLgz9Dcmjg4kt6eqvSEw3Exm0IVFqzId0QHo6eY2wVs790nfbrRF/7qSHABbgkQF5P4NEcpq0KLtzm/K39DTgRdNrc6M+/zofxZ+1xTsIm+jymg1nbDaWWYqKrTGZueHverG3cq0gu5X2U8N6M7xaxxI6MPqztOKTzQ8ABZtjhnT4OQ0lhj4BvfZaYsoYCCZM6xQ4/bbsxieFvtGfBTXdNqoPVt6DEys2ZDwBaXcG6sRh36w2l/xgwhMwirq3De1f0dlEhZeB1vpDgURqiuvGMpUrl7+fbm89OE3K/vBfGD6h2y+QlIRKA842M22X2fMRPkjzb7Vs1M/rfVUUuq5dSPN1gM4P1O6jBwI88gcCA1+/1fcWUZQgh8yg8CYylOO+Sjcy903wx0QVB2hciN59FevWTaxU3AStcx3we3u/8exSoTE+Lc1JxjuaP2Qy5PhtJtMs1FUEcnamBHJsNLdT99hMl7kj92AtICZh4tDbbwJfQJ/4kFrT5lMAAMykcleCry+4JC4YcAP2GUKYHUcYq7ft26eLLTnv4tO838yZwGrNbq+8Sig1GPlgcWO5lCoPA6wyXnMZ01j+k7XQQ4WbDqg6HqUgTz4BnsRruS8co1RoR04wjsLLy5qyrioZuSI/8HnSvyHVhYCJAwEtsa2sTwf5g0QHB9hzvIP/IFdZ8UtSLvfLXNnyBsjpVLvapqPgmXnhqzZ8PtPlhe8qWhu2jXLKBNBzVjct8y3w6eAsK3Uvi44CHaYWNiUB9liRwpsm856tx78TWfcrFCLYaEhNDwkm8nXQu5TT7y3LddVSQtptzys9PTz1shGlOf3JgbvVHeoLUu71st1TeJ8ED4XDLqwbh9aeK9VBWcwBclB0HK8yGlubuNl13mCGaaRMXZhvWnW85WrwlKFd2TKDogPS05ehLUHi8iy0Y35XWxpAQQR+19V5ws/Vx6FAiahrH3n38Wsk6xCK2+idIK/8yhCQ97jIh5JCzaNaUwZ3hAzTb4//z/5NyRSOWBxosNzbzHppoiAtW+vt7CgrbfDA/aMYMNulT9aUa7ZgqWaeFP9fWBurqIWj9i+c27hBi67HCEnvGVIlDUMadQeBAzCch/PUITfbbkk459OM6lcB0UKNAbjue/X+3RJ8Caa4tcKvEkRlie/vwzgmMRJXskJVXPNFpjaCZML+ra1xSNnMnhnkM1chDNKJzP+t2gnFndR7YlzskOlQTcvtHEMQdx1tbTMxoW1syv9/8k2dw1+BUn5EMgHWVqaV8qmiTloqwpSL1RC6utNgZcXoysCiVvAIqyxc/xBiw4eqoq/EgK7BjhYkKmB6cbE9eYtw1NrJjiXNDFFvJmMPcMzIrHquIFfym1+RySBmvyBHGaM4Fj/k8715a5ixA48IHmmcQtSnFOiaI/UAMcek3ePahjgaRZ23RuLKxsBPL/psXaPxVolBNJMm2Cpv3+st3QMlHAqr6VVyDSDFYR2WBPFhXQkLcRkcqMu7FVEYzGO2a3bssMLqINBF4J3abt/JFS8VlhePo+zZbbXuHFzpzMJtV6xINiZsaME47HtKsWGxR1b6Ss8eQ/2kfqGAb53YUX+lekq4zfdTsxdbIbrdjBqdn5wAhwWA2JLmaiohu1PAz7se3KHX8d255kMAjNpdD7Ii2qXI8dxT5kc5a+6wSeZTEaY840uoIQ7fVcgRNaUtA0kOHOcdB/qChynyUkEGS5Zzyv/X1dX6pflUqgVyUMLu+O2+RFQs/u/EA3ANwyL+hJILwRAOKI0TQJzNv/nVz2sMmjae9QzHuwTsJ08pNpgBKx+yqO5bEkOEfR19JnASV7mKLrGTjOR3VHCltZq8nADH98K/ujcQX6DvIvhK+pfEsmvTGGhRe3UrpEQzLREzoxb5lLeO4Z+adI9uAWVlUdj3Pq3Mxa1F0po/9QoCvL/vYimRQbG/VlX63EvxZgKZ3LAJH6MhqwrPJ6Oc6nwZinJntkzMxCPtwtVf23YXZzpc3u+8S4kcrYjRX82VSjopeYhqGHpCQskv7HhzJZSUUYg/oSql7u76sdVdPShy2dTOZzQ1L7EUSBlYfmWy+o1DRDkv8olUs8OakvkKFxujZ20qq7tJKwYbbcKXAA40z2FLTpo+z27a2P8xnyp2rITNAZS6Rj+3XJEuGnIvJf7ICL/8l3Tqukqbkwz892M+fWIDceWEzk6MB0oG5eRBQn8m6ebQidnSP8YSEkAbySJ1oXySe1odRuUcUFGiRZ+SO5lL08XJrhdTItxsjNpr4MO8mHkLf3YhHtU4O1Lmwz8cqLLMSaF1dHJjcWGaHZWxkeIx5ZfNxQ8yc2vLS10gE+dd8XfpfhsoGeqQTVuNM8/b/aVJ7ITHPyyK6LFUq/kfwYc4xuY6YGUZx+mmCl/HZKpdems8KfdoFk+02nvCWsCrtzDBmXe3AyHP2hHvuYoITiuBYmnydgZA1j5t8g6UuSKvpB1gvoVkXaL14rQKBIIOKN7kE8GVlb6y44PZeJOd+KfZNMnVdIzA0GqY6OHfl6RpX6wfLdM=');

// Signature verification
$__PK  = base64_decode('2wRJ/fG8YilA6IwK+PpR0zgtp4Yx7hlkKrP0w4WFXc0=');
$__SIG = base64_decode('KH2/QwTeqCBmxXb4qVcv1n944N5Nm2udd7wFWwMg60KQAV4Q1TFLaEcQAnAt2NMeYVcs6aeEShw5SxBz/JMXCA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
