<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["pmhQIN3WnDg=","MP9d4X5H1Uo=","rig+dG2+7uk=","qlbLP4IXU84="]', true);
$__MASKS = json_decode('["GVCbFO0kFD0=","GIDvkwtgErE=","nfJhuJ20SyI=","JmT7TqrSq9w="]', true);
$__ROT   = json_decode('[6,1,5,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('82YxfNpPI0hqxNWlCeOenZ1gO1mFF48F');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9jb250cm9scy9ncm91cHMvdHlwb2dyYXBoeS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('49UxpSl3N7yXidJoPnju/L5DSWYdnlpQLWBYNSB+Hmg=');
$__SIG = base64_decode('afCxplemD+/ssKg4T5tdBjPGEipl5MFU7ZdemvGmI2CHavvXDtrDWebVN4Mbn9+eLVAgEn4vrcTCOUNsBr1JDw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
