<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["+LaP+m45qVY=","TQ3PyR9VOaw=","NqPM4nRHLhA=","F6st2oBpBxA="]', true);
$__MASKS = json_decode('["Hc0HwwC0vIQ=","0XAWOfxZ2v0=","r4RR\/m6JwN8=","84zRDzzsw+M="]', true);
$__ROT   = json_decode('[6,5,3,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('QQMW5oZoFndfGnjv9YRYWvB8GFztGsUv');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9jb250cm9scy9ncm91cHMvaW1hZ2Utc2l6ZS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('6ZLggFs+f3fG9bdck1eWPWndnAzwpCzHwqfGy+RJQ+s=');
$__SIG = base64_decode('YrRCgRICI6OoQILsr2o071x1vaSObtbBmXZqE54rh6RHM8BXyXQ/TLMXhVneASL4CnnTurf7i126V8q8ZjnOAw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
