<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["k7JVrtH\/fU0=","i2Jmb7CXXdA=","cM3eEr0vBqA=","2dZ9TcDn5lk="]', true);
$__MASKS = json_decode('["zq4SzjpApH4=","QiCAE1iilfo=","3xKJBZsZfRo=","ieNibuK0yVI="]', true);
$__ROT   = json_decode('[2,6,4,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('1K8dRWMFNskteSoVJQXVVpNUeDfXjaT/');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9jb250cm9scy9ncm91cHMvZ3JpZC1jb250YWluZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('PGUN9N5r19HL/cVaqAtPwz5TXHAosxOPFWE62QpkbO8=');
$__SIG = base64_decode('mSj57PcH402eSTy2j+VLu/Mx4kfJcXGWRJX+uzoBZgj5OBK+ZO2IDBDVf05sQx3JO111dElNL5K66N5SviYUDg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
