<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["qZ7R8sSzcL8=","F7h7SWDsIBg=","wBkrPjEee34=","UJb3zlU\/B7M="]', true);
$__MASKS = json_decode('["WA+caqXU670=","aiZi\/ZZt3Oo=","UdWpYnogVGM=","GcVZlhhGAOs="]', true);
$__ROT   = json_decode('[2,4,1,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('a9nyYRPmhUQH/MiGVOyz3iM2BqOKPEJI');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9jb250cm9scy9ncm91cHMvZmxleC1jb250YWluZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('SdT3ug/dQiFERP3gnDKEAfF+5yv8j8+zYJs4gH9dJnc=');
$__SIG = base64_decode('pPNEBCXe9Wde7wLHw/azL1ehIi5VylfVkCGVD8lf2koJcjwZwAurXiyp0Qgbigp/I+bLgvAwL7NvpCqc0ls9DQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
