<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["fJO9GJ5U+Dg=","tGVyTjYndJM=","bjI9aJJZc7g=","Rcvh5vwlahM="]', true);
$__MASKS = json_decode('["j1muPW1a+qo=","w3siyxix4iE=","ihTiA\/Uojhk=","jGT1aPh0Nxs="]', true);
$__ROT   = json_decode('[7,2,6,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('VQXjuHW5NzZ8h3JzyXuJ/EGAaPNOBf4x');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9jb250cm9scy9ncm91cHMvYmFzZS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('J7d+D2DmEdjvuSc4j+uqmRI5fdV9cf6/12hjkreRfB8=');
$__SIG = base64_decode('VLAj4OgUc+niFH2UkDBHMKU+6Nj8VR/ACd2xsuZF6qLB1iePIL+cQYKfEba9Kqx3w0flRc++XOk6T7+/AuwvBA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
