<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["uTZFVD2LP+8=","LfwvZI1Mg7Y=","e27UWNeCCN0=","372151fHkps="]', true);
$__MASKS = json_decode('["CXQTceNoMdM=","O\/XlLhh1Wvs=","IZgL4kbG6us=","mLrZ+HCcCyY="]', true);
$__ROT   = json_decode('[6,2,4,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('f1Y6OoX5Y1XkujS1y706MZ3/OZiNb9L2');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9jb250cm9scy9ncm91cHMvYmFja2dyb3VuZC5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('ZokMaLxNBLd5LGxR/K8cyzUYrg2lwSLiLxXVlC4NLk0=');
$__SIG = base64_decode('HFRur/5YNfh5d3P344lswtuj1mZP4c1jAB3UW3VKm7b4fVzhr7taxlAn8KC9QfISUjaX61Yvetvlp87mcBCDCA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
