<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["gh4g+TU7Eyo=","sAqdDi9\/klA=","KkGCLfKMTqo=","wdtbpYcIsJw="]', true);
$__MASKS = json_decode('["m9nRP8OkjTM=","slQhuG2KS6k=","IIBrceToq1M=","2I6I0p7T\/RE="]', true);
$__ROT   = json_decode('[3,2,3,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('nUDsoz9bOHY5KnlsaEKkEAyx8FTCp3WM');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9jb21wYXRpYmlsaXR5LnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('1wRWtdsX8U1cqDYz3yfdoBImfYhmh/jj4JGCLnUVGL8=');
$__SIG = base64_decode('cesLLFGwgUSSBTtPM1Sv51f0BNetuAypzMNJyU7YzlmJEe0MlB+V3OCEzxA2vs6Watp8ymWBanKUUV90IPfKDA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
