<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["o+aszmXzBKo=","xbtVyjIeKJQ=","G4Ds6bp+nDM=","svu1eQbAlkc="]', true);
$__MASKS = json_decode('["vBEVH7GYG8U=","YcV8DbG3mPc=","NtZZCijTghQ=","QtYWVgBiBo0="]', true);
$__ROT   = json_decode('[1,4,1,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('qCcpyvSrfpJNbz0baYBgKYEbGfF7/grh');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9iYXNlL3NraW4tYmFzZS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('JQgAD7XJ8m55adMO3sxfHXiTciYvaNGefDZ+6jq/9S8=');
$__SIG = base64_decode('WPjA+6Ql8JFKT9kGFJQv6pHG5fEKjvHHTMn3qqO7dayIS/oZTL7jMNM8dQ/KvP4uhuDVsRjNBUQrqh9GkhqQAQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
