<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["3lMZXWMmA5A=","k3PfmG4PiOA=","cxV6fVfp+D0=","fS6BhKiJ9rk="]', true);
$__MASKS = json_decode('["6UKaqna5r9U=","F64\/HapuNl4=","Q\/WZYVQagss=","AMhljgHrKnk="]', true);
$__ROT   = json_decode('[5,2,6,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('lUgbDsxaLXA+YiE9U5ZufLTHwkObENsl');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9hcGkucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('i8hOzJhSHhFbVM514J7PAUL3qetsVHOVSgL1Rd3KaGs=');
$__SIG = base64_decode('xGLnEvfNQmIMO58wOubttadEwB8OcA7+YgsM5YR8kh8VOt0slMzDPWx0IdI1aEUdhkkc0x0gX+y62it8k/QoCA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
