<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["kgGTFUkxKLg=","6otAnIexKFM=","OkESEFD0Hfo=","qGSQaNAiqTg="]', true);
$__MASKS = json_decode('["OcpmCSaxgKI=","6\/egWvUbJ6g=","I133sP0EAPI=","gfws6OL00uc="]', true);
$__ROT   = json_decode('[4,5,7,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('05nMnZivlLgN/5IrebtCEt1JYuCd4ZjG');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy9hZG1pbi10ZW1wbGF0ZXMvbmV3LWZsb2F0aW5nLWVsZW1lbnRzLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('I1m9Hx7nIGFXulyOKsjRLkerE4bfGs+03MfF5VwfAnc=');
$__SIG = base64_decode('BY4WfmEO9oSR4DZKANw04kK4IssUoAVa1Xcpa2meKqEAtmQbK8mdgyet0gievRq1KzEg2VlF4b0QnHiT9BhYAA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
