<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["a94GU29NTtc=","fTdB9+nQfes=","feYPHv0mOCY=","HDcnZls9XK8="]', true);
$__MASKS = json_decode('["gjfuYhcSAAs=","xXrpTR8Z3pg=","+Yr9ui+bWGs=","L8yp\/q4tueY="]', true);
$__ROT   = json_decode('[6,5,6,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('FpMJ7odpkeMlyDdN95u7BzMDlZmrmKoW');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9kYXRhL3YyL2Jhc2UvYmFzZS1yb3V0ZS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('jbTYkhePcjOf0RWjsPdzxD07kfd/glIA+3ObI26WW7s=');
$__SIG = base64_decode('aOAmNQZB56IBHCrZsAbDNZWjGloa7yEGxPaJ5qQowJgl22vP8GwKZGCAGDCHEKy404hM9/8WUutCGQYBwhUaBA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
