<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["t98v0L8ptXg=","YRN99uReKb4=","BFrpWI0AAC0=","G9On1StpDyo="]', true);
$__MASKS = json_decode('["zVmB5uEKu4k=","JIG7o63b5ik=","ySYRgN6a1HM=","LiG60IFgXOs="]', true);
$__ROT   = json_decode('[7,1,5,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('/OMlYUPNajyCtr/fxmjugE9FG7to8MyC');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL3V0aWxzL3N2Zy9zdmctc2FuaXRpemVyLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('ijPuxyXDbmfsUxpmA/H3JEjvuU4hvG/ySKLcASoRUpM=');
$__SIG = base64_decode('RU83nZfB+k/yq23+Dpij/U6h6dBn+R5T9SaQ24igOVdLGkcV5QU5AtDH0rRV5Lb7PJDHiamXzBLeKYYtBFuYAw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
