<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["3qjdPPXEW3w=","5DdygDYxRf4=","i7akRuRZyY0=","0SxAbbXX\/Cc="]', true);
$__MASKS = json_decode('["jv8rdedeeL0=","cIo7EfufSXU=","t5dKlG+\/TM4=","k942zANjcKI="]', true);
$__ROT   = json_decode('[2,5,3,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('K1F7mPCWEa8N39zILrOXOI00yxQoOsVo');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL3V0aWxzL2ltcG9ydC1leHBvcnQvcGFyc2Vycy93eHItcGFyc2VyLXhtbC5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('OCUateAIf8G/8Uq1m7l63KRknezkrexy9h3Rf/S7ZlE=');
$__SIG = base64_decode('E/HRRIO1jLIuFFqlUTYgWm3CAXACAlJkJ4S21tQTyVmIakR5c5QAsOtG23CBSHEz+A1iFwbgGXns9Ao+NsA+Ag==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
