<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["I+83ZwKTdNU=","9uz\/4J1nPKM=","HO1\/AdeIIOM=","gED23HqxdjU="]', true);
$__MASKS = json_decode('["L0D3oEotCuI=","wqZzRTCJ9G0=","j25n5l6BNbw=","xo0j0dZK6XY="]', true);
$__ROT   = json_decode('[6,6,5,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('BM1lFZzjxbjQFnAKnVuDgw86i/jDdkUr');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL3V0aWxzL2ltcG9ydC1leHBvcnQvcGFyc2Vycy93eHItcGFyc2VyLXJlZ2V4LnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('gvWVFnmAEzcq9KQkU4SJBcWti5QzaClyed8F7aEE6JY=');
$__SIG = base64_decode('km9/EcLZH+Q6bZph9xUdo0bGuDy7fKyLFXuSUAYFlv6xKMwqpeCwhrlpmV/lcwcsL/FUqsZEjjQzyWZqDPoKCg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
