<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["1YUudyB6INg=","XvWHJNIJ8dU=","2SY4QFvlIIA=","qYrCBfIns2c="]', true);
$__MASKS = json_decode('["An7tI9fkyFk=","ervMBqbKqFY=","RH5cZHM5V3w=","dyg60ygirEo="]', true);
$__ROT   = json_decode('[1,4,2,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('b+RmUJD/7jEm/ixchF/vLPSABPw6SXZu');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL3V0aWxzL2NvbGxlY3Rpb24ucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('XwWS0SBEPPvVSG1I5zPsee4zmG4ZW3BnqlY5svdefZU=');
$__SIG = base64_decode('2yHPqParRT2/rtmsyG2RgJEP8VORwXZEuMUI5S2mMOwfBmbMZuYdEgFfLKc0c69m2Z/kh7asDa1eoQODMQeVDQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
