<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["+mU2DiIqCzY=","7p+fZGj1Yyk=","DYXUpraGKA0=","LsXBFyzLxrU="]', true);
$__MASKS = json_decode('["O2dPCcd+bm0=","Ixiaoq69nyA=","jxeqDY+y4NI=","3\/99rKmoB0c="]', true);
$__ROT   = json_decode('[6,2,7,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('TNnRBBery4+eihOmjl46BnQMY+Fa9yNl');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL3NldHRpbmdzL2VkaXRvci1wcmVmZXJlbmNlcy9tb2RlbC5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('Dv0JBKUJJIxgRfVkNAEvyrFy7YdG5AAAELOwvvIrFUY=');
$__SIG = base64_decode('pFc8mynjuc+pD73o8097GBm6+HOE4ndJqiRmAytKht8BhSLXYHwoHvON/rX8wLAlFlUMZM73gPStnbliw7ZvAQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
