<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["CZxkdrOsrdE=","TXaTFtEoIWM=","Uoljp7e+mC8=","vjNd1sbqm2E="]', true);
$__MASKS = json_decode('["CaCrtnJ9L4Q=","6bMD8O++SVo=","GkO0Gd1ni5I=","FHqt2slJe3g="]', true);
$__ROT   = json_decode('[4,1,3,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('ZwNxVt20QkwTxYAhw70p54uFMk5wZMKX');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL3NldHRpbmdzL2Jhc2UvbWFuYWdlci5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('HIhfCvhBogfgGEpXuMq05mO/HMqpDum91feGX1SoagA=');
$__SIG = base64_decode('gv5wp7eJn8HFZC55SkYpP9JQ8m7echtNxXEKcF5SGTgboH1HkvE5/2dnx3HN0UBYNTx+MylmUlKCeoJaoh3+Ag==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
