<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["4lPMTzlvmeQ=","OR10D8nKWOw=","h5qQr7M4mt8=","mhv41R9v+wI="]', true);
$__MASKS = json_decode('["h7b9abqvxmM=","TgpvDABDg24=","DhW1z7cfZtI=","5\/2C6NVq4Kk="]', true);
$__ROT   = json_decode('[2,6,7,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('vGA9naiD9Ecq+oHEq5I0n2QzRbLGMqd/');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL3BhZ2UtYXNzZXRzL2RhdGEtbWFuYWdlcnMvYmFzZS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('lQBTqEOQnoTQTgKtWEtX5d9dSXDctbHvLECY5RMm7Ms=');
$__SIG = base64_decode('A9wUNgcLKHF77ttB8zokPER2c6Q5ppFCktXjxxIMUC5potqI3AhcVORVutXzsJBonOzaO3DiH1HuWpTcLLAGBA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
