<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["lM2xEhh3RVA=","h9mCg6TBMbY=","IGwPWa4tnxw=","Hk29m3in9bo="]', true);
$__MASKS = json_decode('["hG3x67B+OBQ=","DeZc0DyNgGE=","s8PVE3RX2E0=","4TeiqxZ2Fsw="]', true);
$__ROT   = json_decode('[7,1,1,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('uq3x2Cpvua20nTylsDGQPF6JmUK+XjbR');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2tpdHMvbWFuYWdlci5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('jwxxK1JXGZ4CaIMcHYWL1/UdTM6Tqc/hmxLdIvI+jvE=');
$__SIG = base64_decode('aaCggG15mtq1XkMJ26qJ/zUc9kOjASrqsIchTZbdAw7gnzjHl7lk5Q1teWq3BdseO31LGZiM6jyrs6fERS+xBw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
