<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["FOxoKDHesZc=","wCeqsGjlY7A=","LyIQ6I7ctfg=","6IiVhS463x0="]', true);
$__MASKS = json_decode('["QKrhUG1kd4c=","E8ZZFrecoOM=","39b5pT3aEvs=","u9GMIf\/PBc8="]', true);
$__ROT   = json_decode('[1,7,3,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('7QgTyz7DpX+dkCBQwHC4tADAbUHPE6eR');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2tpdHMvZG9jdW1lbnRzL3RhYnMvc2V0dGluZ3MtbGF5b3V0LnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('jaOGBI/FvuvJ4sxD6ljNfg2rf+4y4+6QyeryHftsreI=');
$__SIG = base64_decode('wEnETikOSq25c6MdA7PvqC9z4btzZqbqi03nVl0oVVA1PKKQBK98a6/UF34koXSlQwz741lPnntc3Wh963+yBg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
