<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["FeVcKu3RmxE=","uU2yk9v55\/c=","UcB0YZoRB6Y=","fR7QydIcQmM="]', true);
$__MASKS = json_decode('["3THX0EwN+Bo=","3+\/yHEo52Uo=","j\/BCRmmJSyw=","gHcPjgsZKzI="]', true);
$__ROT   = json_decode('[2,6,4,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('ajKMyCQq/ZZZTOfDlVC0rZ5+yHtKpODE');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2ZpbGVzL2ZvbnRzL2dvb2dsZS1mb250LnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('g2mtdez472euRN/M1YeMEel5TS2xv8f0ihP+nrLlYVk=');
$__SIG = base64_decode('iR00r21iB2KWOCeZ6jEkxLQv7hUlGwwJNhpynsLzhtoH2U3TUR/m/2n8pBcv+5De/BCO/U7QvL+f+nApE/qjDg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
