<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["dv+dOu6lqHM=","3eN3abi2ZVk=","N0ifl7xuQao=","PxYtZ5rmOt4="]', true);
$__MASKS = json_decode('["B\/xNvmEuLfw=","ooBzTg6GUlo=","\/g1B+BSb3bA=","uiPWrnea6ss="]', true);
$__ROT   = json_decode('[3,5,4,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('meUBjGpwIyCXLyzOP4yT3TSGEo55RAd8');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2ZpbGVzL2Fzc2V0cy9zdmcvc3ZnLWhhbmRsZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('icrQAWV8bAejaP2idj+O6GbvL+DcqaPXdadgHbm+sMc=');
$__SIG = base64_decode('bb7u2AC2tn6rwfLH+ndNC4Rr3AsP1NU5yWZDRtmkkV09KwnsXcAyjhl7KhEuQlwVfm5kLsx0Xjnsy+WL3sIFAg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
