<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["Trb2LQ+NNQ0=","N3ozI5E5jZQ=","Xgs2RFQQ0Rk=","O04I8vd5HQs="]', true);
$__MASKS = json_decode('["LOJ5MB8mmWY=","JQ0wi4DvvQc=","tdEIRyV7G8o=","s8PrzvYYc0g="]', true);
$__ROT   = json_decode('[1,5,1,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('NPGkcHKiIl+vKVoXJIYpq6txQ4HvrThK');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2VkaXRvci9lZGl0b3IucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('+Wm8L21FFh/k90fdBc4QkUY5ihmE066cXlGvzhjCLxY=');
$__SIG = base64_decode('ybU0ZFINk5+in2GF2kHRgoZ0jQ7x0wGd34XDIRjvNTqVUFBx9Ap9xNhkslF1mkSbixOM7U9X1/ejZKvgYl3iBg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
