<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["3BQYqkdJdA0=","zx3LA5EKerc=","YpC7hCYgjsI=","Yuk5WLxHm1o="]', true);
$__MASKS = json_decode('["h+ROPEoFN9w=","bvRySOFmNiA=","nPAF6L2ahdk=","ycvMcQGKoa4="]', true);
$__ROT   = json_decode('[4,3,1,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('WS8Ygj8+omv7IjLYpOZyRxXWN4T2Sdkd');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2RvY3VtZW50cy1tYW5hZ2VyLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('nmaKTMWtQGRtRcpYE141X5/NPOF9Rq/wxYqOEpW6Oog=');
$__SIG = base64_decode('AYI6UYzwCfN75YC2PS8yYfbZUZEG5L7XTla8omOPdhegTSFWtD9L7c0rrydYZZhKPwp7RI9B7grNzpvk2OFiBw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
