<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["v4iCNQvzYxc=","UmH6c67QamQ=","ulhMAm\/QjxM=","JN0tg79ELO8="]', true);
$__MASKS = json_decode('["HLq7+wSSFOI=","mWdt1V4VWgQ=","dRdOK2Ozd4E=","NJYEZ6CFPwQ="]', true);
$__ROT   = json_decode('[5,1,5,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('zmI/kIXGtoThb924Nt3LlPmrtXeqRe5j');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2RvY3VtZW50LXR5cGVzL3BhZ2UtYmFzZS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('KCeBLeDcnHQBV2j4CQV1UQstSYrWfldI8ZKjxn//hGc=');
$__SIG = base64_decode('IV1L2YoY2FLVZWeRHtusLGfFcZp/fNQ9tpLYS+wg4bXMzkcB+d83mUN20kws/gNDGsJlTFatTaydA1TbryV3Dg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
