<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["vHaUQC4JX\/Y=","B9LqDOimwW0=","98FgUCWQfJY=","9S6YCI79trU="]', true);
$__MASKS = json_decode('["lFKo2LiF3HA=","YR4LBiDefwY=","xz5PuDi8uRY=","evVK9PtczaU="]', true);
$__ROT   = json_decode('[3,6,3,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('U9k8oxpCFxVcGLRfrXVGBEFGri/zeBtK');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2NvbW1vbi9tb2R1bGVzL2Nvbm5lY3QvYXBwcy9iYXNlLWFwcC5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('aXJAI3V2EKyuemYLiKam3C1bpourZ1rbrq33Y3bhd5w=');
$__SIG = base64_decode('KHOOi/h8UY2LyylKBHH6ovnvZ8n7q8vg8t5a6TZRM1dqwOU6ltTBQRWmStBTRmxGBHdCRt2PCUYEyLTEwv7FAA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
