<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["W5bphlxuEW0=","EGVskLdnuf8=","Xk1YnSHT0gY=","KD3Hj\/lw7Qc="]', true);
$__MASKS = json_decode('["It2MKf3nS50=","B0GNex3hqC8=","dAZnThHlboU=","hoczvkppv+c="]', true);
$__ROT   = json_decode('[5,3,3,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('7qhVjcYrxxj1/RSIE9F+pGlR7eMqLbhl');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2NvbW1vbi9tb2R1bGVzL2Nvbm5lY3QvYWRtaW4ucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('ixBS16Uj6G+4S+LGRQEfnCpOrUQFEs93UM1jdfp+kzU=');
$__SIG = base64_decode('qJEnqh8xNw7hyhViiAihyv3knyE96GaX0oJzJS/E+KLYlAOrRy4aikA1sJrT/C64NaA7o6BRXrxKky8o092fCw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
