<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["WZZIzpTORNo=","B2pXMEk7Dz0=","+ooWvdZMsQE=","Y5RVDbuVFz4="]', true);
$__MASKS = json_decode('["2r+Kkp4zsvo=","ppFQ748Z+ZE=","i3dS+wol3f0=","6KAT+FlBAMk="]', true);
$__ROT   = json_decode('[3,3,4,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('mx6casTL3WD4i8+URcqkRV3L0DaW1tse');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2NvbW1vbi9tb2R1bGVzL2FqYXgvbW9kdWxlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('3WZuD2J3itU6+tXYbK7iF8QsKFl9tsCJPQT9QcCM3Zc=');
$__SIG = base64_decode('2WXtFJK4B4I/4Cz0PdFy6Hi5dnhPlK7X+4ep/iqeE7X2Idy0tXjw3L2lSRSbbzho0LggeX+jXPbxhJBxrKeQBw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
