<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["vgfJC9N2rb8=","eNChKwBRXcM=","EYxejp9orfE=","M7spbKW9Ftg="]', true);
$__MASKS = json_decode('["aB7\/nTLA5Go=","pCQOm7ATqN0=","IeSIgsyHCao=","m\/VGeO4GAOs="]', true);
$__ROT   = json_decode('[3,6,7,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('q7+9o/PLPk0Cx5J3yMxXcM9/oaEOXUC6');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2NvbW1vbi9hcHAucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('nMWfZk3hIVsGIPMRRZfK+hGeSl9dIsPoOMHGieZOkKUjgeuy2qTpXw5l/zQYDuZhYGy7JZDs74uqfS9DYe1WuMzUpQcpoLgqVVhdQ7cd7hlAtbY9MezsGmgbQBmNETZPC9XZJ7gJ8PPDzuFn64zYEkE2wiwfutQZdzgVv+Nn9PKe+8y9SmKmFq6FHm0DsTFJA1HH4fA4kujyeav2ZChOmBbU5q+eY0OJmaOZ/jHaSGcPHPm+S/Ij9UKM/YksPOJM9CgAPyN0SysWCQHiM7t26LSTWXg7XgZwqm8qlIWELPJ7I8ol8eBd2opYyPoqOUry5lpfYeEhViuSyqVjcFa9b4xzgYMPZAUxBdMx1wP5UzeX9gZLBQhK8HnqhPhFiMNlnUIf0Bk4dpomiOnfFgQSE+0Hn4bO5vFp3onUXEmvXY5Mlaqkhjdb09+mEUCmxPXVeK938QS4NbrHDXl1Ci8EDLbEcvWcfRGX1/Hed5/36+9NxOD1szybYKGFdPprcsoiFp8YQ6xmEsZPEfWiXUNVeqn00sMkOqb6jd2CYISXk/xnGT2fk4TiusCYL460Q6ojAS/9JftS8z+ZJPEMy7he4XQejvKVVV7VAi5YTm+tdv+8H1C+g9tncdYBlOdK7C2gW9xrW7SS6LtNzzlNCyqxHZZbgV90cqFFhfas6IBo5GKVZuNj5yOwSJIevS/2nK5tccm4OBQC4ISqA3fN+g5RYspYQuZZdbrtVkYK+daMyW+ObEnUFiaCQON3d+TF3BfNtOkDCN31nIqJFQNBqvaNuSG8GUPZY9tYqd5coLb0cw4XFoN1Mt55tyvItnnqq3bVNXK1dW5iCt5JiZg9G/Dd1XKUY3Q4IYpuVX9fOsdvKfGP6Lm36psvZAbEM5rghweezUZnxNwOeF3Fo+S92XX1mC6qWmyB1oSWx7nqWcyOeXffK0/wjIlTggAYL7Euxr/KCFAqk/XjZZkdUIgkFmO4cX4Eg4XAbFVd8ExP/BJXZ+CVHMFaafMgKbYJkU6k4QhelcpjsTWuOFg3vMZW1zx0AOijMMNx6A7/0y+maiLG+I2Sf8My8wWYazjr+NH4IrlR5feRHs2dgJtimkADYnYeb7PubdPzTOgLarxGXMYOOKRKLVd83wHzZQPvDWu4Bi5MxAkXsQVHH9FaQdXaFIrDF9QIePZYlTnjmuK64anloPwkX85HDKlq56yX3mXTYktIQbY1M4JzE+z7UhxmTjV580cZ3MAFn7DmK+EUm5py55h7xyXQ/U238b9ARJUOUME6Y2ptrdYLmDiKg6hEHOJIwktg7LJDACSJI9eeA1EPr+LZpKZMsO4ycGD3Ya/fs9AhSB8ha7CXutmNfy+WTA+CAHEdjlRXmdOzTSwR/6qvJWV8sOKACAyY35NlkK/ouuo1PQ+LWRCT7Lzw+l1hkLdYiRCsh3tUydYHwsiwhfIa9crNds9TNc6lig1dCv62nkYfisKmGWuit6onkynCJp4T128yg/SEIS7IhcoeDnPs6Fq/FyQy73IuysFPVSVXhyVmP2OFkh91KM75PFoTkiKZDY9QtEBRseDTdPNAbq7KZSGVZviF/J0Q1HD64xLTXDJrYyuy8extGEva0y6A4lQW9xZRnANiyBxmicYtkZsfBHkIZfhSBEbRnr1UA2loN3CusOLAa3NJ/qqAWKNY+3IEjv0fw53QOu4KhxG5lonUIpcEMdWGOc5WqHNfn3kyJjnHXhiC0kh6N913We0I4IHl6PAnXM0Z4f5tkbWVWJOrYXiM1xig/foZMeUPNcjF1OvQ8I2SbFwAZYqTUfMUX43Czs2l1p2oR266woRA+/Lh5Ye4OmbafXkDmrFeg6+6qgODwcxIme6YZhIwkKXrK+S1XmZWVqfowe5bz8ALT3wV+KzxnP/fQ+u/h9VouVe3Jj++jQbESnJ4Ze30J8VrNK6AdOqxzmhOmEz0WxKwq7P0dn9TcFi7Bz6LfQ7yXYNbqwG4T4lMv4DbfDp58AfJw1iyzUEQQnjAwH4NogDLYShmpUKv6W+NFYOGyNpg6BwfPjKyE7KWZeZ7LhNOyZKyYYwVnzzG4KAXJ18HvDXTgZfBigKB/dxEa3jAyrOt8l93SGrkqoW0xdfccmoJmXHXu+hRtDbdOYq+RyNub2CdWNxf20XjLQmmZQ+RFjOROkCoyNyx0LuxzlF2d0KXWdn/F4KxKLSxfRuNjlDx2MBKDCNT3cAoiiDLCBsYpJ+kZiTbg8UI+ksJwKzIQRTc1Neyxu//Eulp2YVsoYt0fxExRDjySPAxVe3pnv3NVjsrqD4PAsKHUyRIu0PY4RsyL/l1Tv++7Ota3dz0X4z1lGug62G2UJEa2SiOjQ8hy+pSfxpcFMJVL93gP1Tmdy1YpSA60u++mi9whQqtCt/bxsvQtiybSAGCcIY1x6s62toCZYlNqUlYV8GF5sai3RNybBB2z65gUGUqRJnEo/GNZRZviKCvtv+ZLmObu92PWGuf22Sscw3ZokMzCl6b1nvQeXYkN5MQGVACl88fWusqzJxhm+oxotoJ8VG48/eUYRJcRI4saCjn0KUhiN1OWqsZB9Bdlam4c18NV+vDynY6VVMD2ZTpMSsxjGaSE08XC12ON9EWKyZ/DJV3zXL8W5LiyCOLvM+oaF7BY2SpRgtfPayvCH7qhuXGcofIzmDJivfbAmdu+pAHiOEYKGwi9RRPCIUsJvvmYMWE8ntgHj09UHsVOMzkP0cCiMFXhcKbgRbbnymw7SwL25lZxh0Ori4EAF3X6zXMHSVEyWI4InEPTXVFfv+JU7IXkSgG4l3h6RkPr49SiX08nhZD1BBlaBU1ywiGrXg4NbRRMO0ECxPFKr9Cb1lqrAvj5YICUILmrxf+aEJW3R+fBqUn4g0gQF+mrgVX3RqP3TBL/ZrYxTKdCmhj0KieYRD+vS46j2J/w45+sBlw1l937XyLUqPm/62rRSfF0GQkYdUW5H/hiqfYE84P4Vn752W4Ya6E1V9gDDMwXUIF9Msjy6pj8sQq/DE1p65MIL6WNcjXMFF/prm7pqSGAgtOEfO/DrmftOfolj6XXy1YzF9zStZiYWELwSuC2ffeek4tVbylm1rMAPct5jKfjp/j9VUFj0fQ79Zg0r3i4AI1elVE3S5OZb3oAM/yk7d5rPjHhs3nsXDYnM18iOioIlsh5mgjmYUDL1fbtdzEWqalhDHCKhS68kPh7DJRD0XoGp4sMVSVjg+yd/m60zIn1kXNbXO2bhJzxkyAzjpN1LfIV9+lgXYD1Zm2/4QkxMkcM0btqUjN2Tk9zpC7GlHZYAxYUn6Uelg6DFvNRxbHdy4ET7w0v3NSYzuHj2mRCpPmbzgU2mTb6mhnsrmlolUlknA7DUkLodmtceg44+uB0xYGrHqqLum/GZ9oFOD7MkSe/oasxjku2XKrPUwYk7kqsw8pibtEAErzRgNikJofhIVA0GgmJFRGYbEA/GBggEv99EU+keVskcv99cwH1cQITQAU6qG64FPNPpGQoQK5tpKLA/2A7TXmyLGgIrjOgdPkmhEMV0yj8MXDsU+rD6FWqX6zzCuLGUHRLbgU/90eosYf8yQwMSxvkM41oufnghrn1JFBccoE+uaW4ecydId8PpWmvJqBUQ5JpNxt8y6VmfGMnA+MtaWjOc3vpSZMhrup5RAZELcMYCv82Wm8FzXHIBRg7wgMcJnoLwpqoxmQaThu2LdweaTYViLsB9u3NknlW2BDDQ/6+SLl/p6zXwkm5WkrvtyO/C7sJvqOasrAHFAdhaRcJr8ozhr6cy9hVJgq2S3EVW4zX/sVALV+8d6/vjIQKSthRSL3i8O0NMDE+5qUrgVJeWbpP9D+jOwwYMqUOREflujOO0Nkc+ZYRcKyV36KESqe2LkjpGBHPFjjIJ13zEQxoQGd+L6MKSACfDVNYMg2BfDJlHq4lKsQsuKIXJXmmXwNTbkwagh6sBt9jzAf0glwIYTiBbTRYrF/KTkjYq+W76ZPIip/3cbOfVMgcOD6rhKJbKQWsPFGuQE6MDyBsYr0/yiXt3+kUwTCAnDgW6O+eeQU/1iUK+wjh/+VzzXuQg2tUw7Im3JcqrruXLrUNpvACJjxm7bLXAAPVyGDuOR9fnaAFHHvOV4lVyHrRsaJTI83qV2oV4RJiwP233PwGCFcpL9MyaW93lQhJlbzLDIEOL8OESNgj7KkKJETBTrVlwAlj2xxI8In7vwsQ4TUWZqB86UFS6JCUtvMjlnAOBQMOXUXQbACzOMXD0Wefg5DuUiiMdS/XhPivCL2TDhfDwu8LDdluAxa+RXfFtgsdXAh9LI7QV/c+TSCQEt/O6a5k6VN0oQ9qOOCn+8COW71kXDJ25La+k3AkqQuuSrVInrAleeFTxsm/SZpBzOJ5DM2PyYomh8pIs556Au29YtovbndqE9Y+Djd0H1OrLhSzJ1ja1JjshjExxyotNaOk31o2GitujUbn9EOfgUKfjhO2td6Wb8wz2bDU2DNsMJwciJ2yGU27L9p+net3k86eCtaG+Zz6qeuSkONcw6fkqxspZozna8wP4CRByIpJOX8G0BS1SAhRB/u8AT1HPDgLc89EnYcaAJ0XbvtEyddbEGfu+ZDW7QAfD5ipk1/M4948Ht0IFQHL2qvKZON0lVmTPl+7r00NZwwq7tG+aE349xLuWN/Mvat9hbSrXzbPP3q+9/bdjP4mjGnU7fNoRi9Jb5pWUO/VKPsJOgFLj1VAa/PczvXZqJqAol6Ic2GZoTPj4tkwqNb66B5XTgOkuqQXr9NYByBH9FHyiCZmzjoswpPuovu+QAaOkwHv9SGCgEmV9vlOvwWjDbc1E30ZsPpsNr9avqYcoFMb/Yg7jpSpEty8KDNSowF7/+c3JVxy2YryHzMgndvMrz5j3vglAaysG/gjSzs+jyK8ngm+AdzrrcTZeLEwj7ohuVTkXG5ERiUq8t22qfka5N2R2yN36RZq4bfBv3tPDSG6nfAMgpI21ksuLqMd/nXB65QVrRl8/JdFbmcKXAZb4gLiHK3oZK5enbL5IPpYYfIP17NjbEz1+DEPx9LcP/rrc1F3160WYEOpHHcO9tRrF5uGL8RReLfjnzva/TpUT1YvgxP2STIMVT83ms0vAmOJR0qMfFVNtUKlSxc3yw3n9+2Yeoz97OtkfC0Uvo5x1PbhPYb1mFMMTl6O7Wd/9+vFEZWx8Pwq/3mitM77z6zioMOl1UkawbMbY0GEB1EsLbpxgmO5uM3JcNQU8cxZyOQBxTf6ibHXpgbTi+zLbsQg9CHXVU48+tV05N9zK18BOAsXs+P/wxBYcAUHzUrtF3WJfzBtlMhHhl4gQPlTB9wKSyqvEdqCgKyseylxR8bhuxNqqd9LOlxgOiLZSl+XwFyycQBtluWgaSqLbM9ameQ5smsMUPc2AzNj8V3Mb2NRXyLqEc7WARLxIMX4rIb8fN8C9aa2aFxa10MZlmml5X7vmbwW8B7cKpu59IwQgEvzVpJKoYXYLgUuDE4HgXmzasXDZ0LgMF2wJoKn5t67VwvHH9TBmG0rLaphZIn3sgyPp6R66TjF+Lz7b9S7lfmrn89quKqCpWey9wCEQk6pZrXZ3t7EMDIPdCBEx30Hy29AVOVR4j8czbvybHCGbz2j+DRTF+x9KaBwlUKCxBTbVk5gG/fQoTNMP+AAsUW+n+7/pjlwIz4V8Ri3BFJ7C29mCiP+KSJ9Z11HEsj1XJf7MGI9Ao/OlLOzMZHPE51QagHg8pGN0raZaWDUkOEsfnbwd7Dsy0rfo4OUR3ewZKgF93saMz+H8qn7WkoKPU+2rcX/2bEsA42iJyAjVcRENt9Ukp4s53lp1ArhXx/hB6Afhh5j1FuFW0vSm4Tc/KIoaC/6MwtDIVf0EY9m1gpYeL+G9leCrZjEUj567lkZ6hCEGj0n+nKYLV4wSCxriPFPn5uKa50RDpDI2rLWuzWqVcCvTIoKYZSwNioQsnBwJ76Xcpff71k11ePYH73QisZJYgTgVR+n78+7yJh2NELneFUWCVnwTvG4IKr/5xXNLEipJ/HmmoTE+D1jfVFxG+vo+ix1obNzfmeslQ08NlIWgkCdglBHEh9z7dAN1N9xXI7RrhFF2J7ZSR2ZUnlONA8tKw1BaAq/q5yFCATGGJ7R+ef53IZZ54rX5vxgvmgIWjsmSpOZxXjbjt3/C+4iFMJpVojiT/19Gg7P/g8A5n40nJwGSpOsGau4Hyw4e/X55o4mASa3PMrhUU398DJ2K8aoJrwh6cvaj8bPXH9jMJz/Ztv+TWDMpEDknmz3YwhVpMuy4K8n2UtVgsttv/RFkkq3Ca+l12Kd9dIYCRH+K1RDvMonWL0Vt+iV/eFk3C7bzIsYjmonSuY3kyUB/v3xVidFYagzj0mKNAMLr4aZEtkMZRZEHATsPdzYj3dGXaiwpvMOgLpj2Ndga689UIKY+7JFoJyRk6Oc/5EKcm5W8txOvGffq762//hgkb55gi9EoMxXD60kQrDD0d4jXEwqU5EGyUTwvX5CyK9bYU7kkadTrmEVWzzseItA+YDjDfczRF5n7BQ4qiM5WgKUbqYv3no/rebJUmFu4G/qmTTN1MuAjrTMY7gHAkFDQtdFhz58oQktc5zCdOC0RBNKdyYhHCxH+8zkVvmRzVqUHIeXcOGvnn+cJOWV7CUC5hkKcSzZP51SA+LaUIfPC5Koekfb4/bk36baXoQ/g/WOKgrfX3v+3Tzt2kYG3HsRko2WWuZS9C7GNPR9jXG/T+D6Wnoesk3qb3vgoszJw1vnFjiY9qEbS49DmWmbGS4ao3ko7059mrCuykrOJ4b/MEHZ6abDpsPJ0B+HMo4wevoWtJ10QmfMb2OGhPDba6W2/PS0lmDfp06gWFpErqL6N0SQUDPC1R1inize6OBzddEBlhrmvIAvNCJdWhKCLJV91cIbIvcg3cWSZUnAYxEYGqTcoHSlGFz8Y/T5akU2qqF8DgPgQ5scffAdOwvWJBqzlyaJ6qjdbhUYISpDqhc6PyRxgyTGly8FAtsr1fcqDjBeZ2FrmYjgSczXHXcI37roxGgDyV7VHauIIt1QWpk9WGRYZnqj1TZHJ8SlOrU7NSLV9DIcj491qqVuztnSMbQVZrEb3tUo0W/xUV8vBHtKcftLk2VPd9P8gH6JQsSvFUP51bWGOSgbcTBXb9siZY/NHcso7KlvMCUJ4u7Pu+9l5VdxUv9nxHKMK33XTK5eCLUl0vZXZKajKY8Ah2QBH1hgKPguRYK3/raM9ZJE1+q8qjwOXgbqVEO0Ul4nQS63HZKJ8hyJKeRqofxGvLrsRXFSV3CqdABG9bzck0qszRvQSrdzfkjrQedT1YYasQYIdCZag2zpu3420ViSSI0CJ2RhJ6JywMKqR7blrm3qVhU/2meTCAZ1ug7KByzwtHaa3KwLdF7AOc7JwCOKPWXZfHFDmFRqb2h5MVMBMDPXWn9jbJOaZUuSVo7kEVeaU/7RYDuscXEnkd2IxCdpwOC8OKVPeKVUix/9ppf62JZ9ZjVerZnFy6TOMLDSA3r1M9+TssJsBKAL63euXQOt4cV5EHnSUHiE7EmiZGPFHkRHWV4FdwkvXndERANclk3ftswKfnU3pqOmB3liohGV9Kj88+t2Vp7QwQHv7Q0w4N+NRboTgx7wK52fp7t+MNxv96VtxX/ZzwCUCmVgKw2z6OYNCNfOz4FRRB0gYXt1nGUQBhPXzFUfA1oCxF+59VVqz0vrwkciK7IvVVZOsB0ECxEUA9E5BTDDwjrLdOgd4Il3eVNBBB3nR/j7i7wVAAa8K3ZEHVm+2VmqfFHwU5NBX5SYeyEs6ta32hq7302//d+pYhIq3AL6s8ZxmKXetXWB+bqd7mMGXaEVtRYXZrZfmhyxfpmglG/z/OFl56lHkoIwX1b2Z0Ij5Yk6yRWgmvIzVHTW4xvPGIdRJpykO/iGTesqqVsyKLz1UW0JrlHtc910lqofogyHeEGhsvzDWahLAyev50JcG5OKTJBaS5a2CM4PdLFKKAoc17RBZ7UpywcQ4M5WT+LMIpVGUGGe8fh/Su4j+pesTlcdZxhky0MrmEYwrp7oK1ke8u41CfJ3u+7foowjJSzb6Uy1vNii+fgYMI9ATTiTzagQyaL6q6XNYiKm6WlP1A3+YivmFc74cxQXt4cS3qybOIAXRIlF+RdQ6cDkRCwCsaVv3Qwe7obm6sOaS+Y+nb0H7bi+TKgZTBIqA2DaOHvlPnB8huY3+FyFbVASK3F/iIrpV0pn4HBvB68TGiT3PntBIx0ffxorj/GmyUJGQ4kEnC9AkJKbPF4jfQbHv4FKA3Ie71ETCoaARBB8BnYyLRM2l3tHgRef7R7T0NEVJS6gCirARdlBqgdZvCWbwGaZZ0RzJiWbsSxC8NisqZT/5OT1YAL7LJ2Sov0UVNm7kNMcgiIR0LpTYRmdyEV4p5f/JnIdG0na64zHVqeGeY1MSYvxd4iBipQchyAC0J84UeKuo+J41I1L30c57HwOoyf+7tpwwtBXP0AFqEWcHeLyNg4qAzDTFPE9oQ0MeYu4yN0JV3tH/wm5l9nTv0PXWMwJtuAldiO4TagYOXnWcJZXS/9pb92MGDqNDH+nKlPhQXvAmCu6p7StDTlF6CBxlBi3giJzHOc3/JwR0cUdr2p7hZByauT1xz+zDPxRBZo4U4wNsxJPrrusJ4RVZHzBTtTkC3V8uAx');

// Signature verification
$__PK  = base64_decode('5+0QnZqnaL5No/oWcfFbxvz7Ybt/GPjrz5nZbC8VFj0=');
$__SIG = base64_decode('a/aTrqmn9IaB6e2Xjl+gSe44QI0SaSqlE2BNhRTCfdvDwgZeNymh/2uZZQ53FPLmjmPosE1AOwpTiYq17UYzBQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
