<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["y\/9LokyVvec=","VHVGqVmfjag=","M6Jbbbk5G1k=","+0AExcK\/FPg="]', true);
$__MASKS = json_decode('["oGS1BQ0Neeo=","ULtfa6v7Jls=","kNggqjZryuo=","aJaHzT0Gj8o="]', true);
$__ROT   = json_decode('[1,2,2,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('Qu049OwvJz3AJkzPTRF46UXOu1TTkC5g');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2JyZWFrcG9pbnRzL21hbmFnZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('VWjZep9IaBotuosD7afOtW+ufAs1l7/kkrDnL1N2eUc=');
$__SIG = base64_decode('Z4yQ6y0oq4XwJYbKwbWx69MabIuDOpKLWQH/+ba7mHwpjAJKZ7foGACOnHTL9KA1/7iJHZlrd6i38H2BVqXwCA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
